<?php

require_once("../config/db.php"); //Contiene las variables de configuracion para conectar a la base de datos
require_once("../config/conexion.php"); //Contiene funcion que conecta a la base de datos
session_start();
include("encabezado.php");

// consulta para llenar tabla 
$query_select = mysqli_query($con, "SELECT r.idreservacion,r.noadulto,r.noniño,r.color,r.montaje,r.centromesa,r.platilloniño,r.pastel,
r.descripcionpastel,r.total,r.anticipo,r.saldo,r.nombre,r.direccion,r.dpi,r.telefono,r.casa,r.fechapago,r.comentario,r.eventos_ideventos,r.estado,
l.nombre as loc,l.idlocacion
FROM reservacion r
    INNER JOIN locacion l ON l.idlocacion = r.locacion_idlocacion WHERE estado = 'ACTIVO'");
$num_rows = mysqli_num_rows($query_select);
?>

<!DOCTYPE html>

<html lang="es">

<head>
    <!-- Title -->
    <title>COTZIC</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" href="../img/cotzic.png">

    <!-- Google Fonts -->
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="../../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="../../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="../../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="../../assets/vendor/slick-carousel/slick/slick.css">
    <link rel="stylesheet" href="../../assets/vendor/dzsparallaxer/dzsparallaxer.css">
    <link rel="stylesheet" href="../../assets/vendor/cubeportfolio/css/cubeportfolio.min.css">

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="../../assets/css/theme.css">
</head>

<body class="responsive-mode">
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">
        <div class="container">
            <span class="u-skiplink-text">Skip to main content</span>
        </div>
    </a>
    <!-- End Skippy -->

    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">
        <div class="container space-2 space-3-top--lg space-2-bottom--lg">
            <div class="row">
                <div class="col-lg-2 order-lg-3 mb-10 mb-lg-2">
                </div>
            </div>

            <div class="col-lg-12 order-lg-1">
                <!-- Checkout Form -->



                <!-- Step Form Content -->
                <div id="stepFormContent">
                    <!-- Customer Info -->
                    <div id="newuser" class="active">

                        <!-- Billing Form -->
                        <div class="row">




                            <input type="text" name="empleado" id="empleado" value="<?php echo $_SESSION['user_id']?> "
                                hidden>


                            <!-- Busqueda -->
                            <div class="col-12 mb-5 ">
                                <span class="u-shopping-cart-step-form__title">
                                        <H4 align="center"><strong> ADMINISTRACION DE CONTRATOS DE RESERVACIONES </strong></H4>
                                    </span>
                            </div>
                            </nav>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12"
                            class="tab-content-center d-flex justify-content-center ">
                            <table class="table  table-condensed table-hover table-responsive-md  justify-center "
                                id="tablaVentas">
                                <thead>
                                    <th class="text-center">No.</th>
                                    <th class="text-center">Fecha del Pago</th>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Telefono</th>
                                    <th class="text-center">DPI</th>
                                    <th class="text-center">TOTAL</th>
                                    <th class="text-center">Anticipo</th>
                                    <th class="text-center">Saldo</th>
                                    <th class="text-center">Estado</th>
                                    <th class="text-center">Ver</th>



                                </thead>
                                <tbody>
                                    <?php
                  if ($num_rows > 0) {
                    # code...
                
                    while ($row = mysqli_fetch_assoc($query_select)) {
                        $valor= "";

                        if ($row['estado'] == 'ANULADA') {
                            $valor= 'hidden';
                        }
              
                        

                  ?>
                                    <tr>

                                        <td class="text-center"><?php echo $row['idreservacion'] ?></td>
                                        <td class="text-center"><?php echo $row['fechapago'] ?></td>
                                        <td class="text-center"><?php echo $row['nombre'] ?></td>
                                        <td class="text-center"><?php echo $row['telefono'] ?></td>
                                        <td class="text-center"><?php echo $row['dpi'] ?></td>
                                        <td class="text-center"><?php echo $row['total'] ?></td>
                                        <td class="text-center"><?php echo $row['anticipo'] ?></td>
                                        <td class="text-center"><?php echo $row['saldo'] ?></td>
                                        <td class="text-center"><?php echo $row['estado'] ?></td>



                                        <td class="txt-center">

                                            <button class="btn btn-success btn-xs"
                                                onclick="generarPDF('<?php echo $row['eventos_ideventos']?>' );"><i
                                                    class="fa fa-eye"></i> </button>
                                        </td>

<!--
                                        <td class="text-center"> <button <?php echo $valor?> class="btn btn-dark btn-xs"
                                        onclick="pagar('<?php echo $row['idreservacion']?>' );" ><i
                                                    class="fa fa-ban"></i> </button>
                                        </td>
                    -->


                                    </tr>
                                    <?php }
                  } else {

                    echo "notData";
                  }
                  ?>
                                </tbody>

                            </table>
                        </div>
                        <section class="d-flex justify-content-center responsive-mode">
                            <div class="d-flex justify-content-center ">
                                <div class="page-header justify-center">
                                    <h1 class="text-content"><i class="card navicon"></i> <small></small></h1>
                                </div>
                            </div>

                            <div class="container-fluid ">
                                <div class="row">
                                    <div class="container ">




                                    </div>

                                </div>

                            </div>
                        </section>



                    </div>



                    <!-- End Checkout Form -->
                </div>
            </div>

            <!-- ========== FOOTER ========== -->
            <footer class="position-absolute-bottom-0">
                <div class="container text-center space-1">
                    <p class="small mb-0">&copy; Alfanet. 2022 San Marcos.</p>
                </div>
            </footer>
            <!-- ========== END FOOTER ========== -->

    </main>

    <!-- ========== END MAIN CONTENT ========== -->



    <!-- ========== LLama a ventanas Modales ========== -->



    <!-- ========== ARCHIVOS NECESARIOS PARA EL FUNCIONAMIENTO ========== -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>
    <!-- End Go to Top -->
    <script type="text/javascript" src="js/jquery.min.js"> </script>
    <script type="text/javascript" src="js/reservacion.js"> </script>

    <!-- JS Global Compulsory -->
    <script src="../../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="../../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="../../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="../../assets/vendor/bootstrap/bootstrap.min.js"></script>

    <!-- JS Implementing Plugins -->
    <script src="../../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="../../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.legacy.min.js"></script>
    <script src="../../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="../../assets/vendor/dzsparallaxer/dzsparallaxer.js"></script>
    <script src="../../assets/vendor/cubeportfolio/js/jquery.cubeportfolio.min.js"></script>
    <script src="../../assets/vendor/player.js/dist/player.min.js"></script>

    <!-- JS Space -->
    <script src="../../assets/js/hs.core.js"></script>
    <script src="../../assets/js/components/hs.header.js"></script>
    <script src="../../assets/js/components/hs.unfold.js"></script>
    <script src="../../assets/js/components/hs.validation.js"></script>
    <script src="../../assets/js/helpers/hs.focus-state.js"></script>
    <script src="../../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="../../assets/js/components/hs.modal-window.js"></script>
    <script src="../../assets/js/components/hs.show-animation.js"></script>
    <script src="../../assets/js/components/hs.slick-carousel.js"></script>
    <script src="../../assets/js/components/hs.cubeportfolio.js"></script>
    <script src="../../assets/js/components/hs.video-player.js"></script>
    <script src="../../assets/js/components/hs.go-to.js"></script>
    <link rel="stylesheet" type="text/css" href="datatables/datatables.min.css" />
    <script src="datatables/datatables.min.js"></script>

    <script src="js/sweetalert.min.js"></script>
    <!-- JS Plugins Init. -->
    <!-- Libreria DataTables para talbas -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.css" />
    <!-- <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>-->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.js"></script>

    <!-- End Skippy -->
    <script>
    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of cubeportfolio
        $.HSCore.components.HSCubeportfolio.init('.cbp');

        // initialization of video player
        $.HSCore.components.HSVideoPlayer.init('.js-inline-video-player');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- ========== FIN DE ARCHIVOS NECESARIOS ========== -->

</body>

</html>