//mostrar el calendario 
$(document).ready(function(){
        $('#Calendario').fullCalendar({
        header:{
                //botones del encabezado
                left:'today,prev,next',
                center:'title',
                right:'month, basicWeek, basicDay, agendaWeek, agendaDay' 
                },
                //poder seleccionar el dia
                dayClick:function(date,jsEvent,view){


                        $('#btnAgregar').prop("disabled",false);
                        $('#btnModificar').prop("disabled",true);
                        $('#btnborrar').prop("disabled",true);
                        $('#btnModificarTodo').prop("disabled",true);


                        limpiarFormulario();

                        $('#fecha').val(date.format());
                        // llamamos el modal 
                        $('#ModalEventos').modal();
                },
        
                //Para los eventos en el calendario
                events:'evento.php',
            
               //para mostrar el titulo de evento en el modal 
               eventClick:function(calEvent,jsEvent,view){


                $('#btnAgregar').prop("disabled",true);
                $('#btnModificar').prop("disabled",false);
                $('#btnborrar').prop("disabled",false);
                $('#btnModificarTodo').prop("disabled",false);

                //h2
                $('#tituloEvento').html(calEvent.title);

                //Mostrar los eventos en los inputs
                $('#descripcion').val(calEvent.descripcion);
                $('#ID').val(calEvent.id);
                $('#titulo').val(calEvent.title);
                $('#color').val(calEvent.color);

                fechaHora = calEvent.start._i.split(" ");

                $('#fecha').val(fechaHora[0]);
                $('#hora').val(fechaHora[1]);

                $('#ModalEventos').modal();


            },

            // Poder mover la reservacion a otro dia 
            editable:true,
            eventDrop:function(calEvent){

                $('#ID').val(calEvent.id);
                $('#titulo').val(calEvent.title);
                $('#color').val(calEvent.color);
                $('#descripcion').val(calEvent.descripcion);

                //dividimos la fecha 
                var fechaHora=calEvent.start.format().split("T");
                $('#fecha').val(fechaHora[0]);
                $('#hora').val(fechaHora[1]);

                recolectarDatos();
                enviarDatos('modificar',nuevoEvento,true);
            }

        });
});


var nuevoEvento;

//boton agregar 
$('#btnAgregar').click(function(){

         recolectarDatos();
         enviarDatos('agregar',nuevoEvento);
       
});


//boton borrar 
$('#btnborrar').click(function(){

        recolectarDatos();
        enviarDatos('eliminar',nuevoEvento);

});


//boton editar 
$('#btnModificar').click(function(){

        recolectarDatos();
        enviarDatos('modificar',nuevoEvento);

});


        //boton editar 
        $('#btnModificarTodo').click(function(){

               var identificador = $('#ID').val();
               $url = 'configReservacion.php?identificador=' + identificador;
               window.location = 'configReservacion.php?identificador=' + identificador;
              

        });

//recolectar los datos 
function recolectarDatos(){

         nuevoEvento = {
                id:$('#ID').val(),
                title:$('#titulo').val(),
                start:$('#fecha').val()+" "+$('#hora').val(),
                color:$('#color').val(),
                descripcion:$('#descripcion').val(),
                textColor:"#FFFFFF",
                end:$('#fecha').val()+" "+$('#hora').val(),
        };
        
}


function enviarDatos(accion,objEvento,modal){

$.ajax({

        type:'POST',
        url:'evento.php?accion='+ accion,
        data:objEvento,
        success:function(msg){
                if(msg){
                        $('#Calendario').fullCalendar('refetchEvents');


                       //condicion 
                       if( accion == 'agregar'){
                   
                               window.location = "nuevaReservacion.php";
                                $('#ModalEventos').modal('toggle');
                                
                                
                                //alert("evento agregado correctamente")

                     
                }
                
                
                else if( accion == 'modificar'){

                        $('#ModalEventos').modal('toggle');

                        window.location.href = "reservacion2.php";
                        alert("Evento modificadio correctamente")



                }
                
                else{
                        $('#ModalEventos').modal('toggle');

                        //alert("Evento Eliminado correctamente")
                        
                        window.location.href = "reservacion2.php";

                }


                }
        },
        error:function(){
               alert("Hay un error");
        }

});

}


//para el reloj en la interfaz
$('.clockpicker').clockpicker();



function limpiarFormulario(){

$('#ID').val('');
$('#titulo').val('');
$('#color').val('');
$('#descripcion').val('');


}