<?php
session_start();

require_once("../config/db.php"); //Contiene las variables de configuracion para conectar a la base de datos
require_once("../config/conexion.php"); //Contiene funcion que conecta a la base de datos
include("encabezado.php");

?>

<!DOCTYPE html>

<html lang="es">

<head>
    <!-- Title -->
    <title>MAHVICK</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" href="../img/cotzic.png">

    <!-- Google Fonts -->
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="../../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="../../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="../../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="../../assets/vendor/slick-carousel/slick/slick.css">
    <link rel="stylesheet" href="../../assets/vendor/dzsparallaxer/dzsparallaxer.css">
    <link rel="stylesheet" href="../../assets/vendor/cubeportfolio/css/cubeportfolio.min.css">

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="../../assets/css/theme.css">
</head>


<body class="responsive-mode">
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">
        <div class="container">
            <span class="u-skiplink-text">Skip to main content</span>
        </div>
    </a>
    <!-- End Skippy -->
    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">

        <!-- Services Content -->
        <div id="servicesSection" class="container space-2 space-2-top--lg space-2-bottom--lg">
            <div class="text-center">
                <br>
                <a aria-label="Space">
                    <img class="mb-3" src="../img/negro.png" alt="Logo" width="250" height="170">
                </a>

            </div>


            <!-- Cubeportfolio -->
            <div class="container u-cubeportfolio space-1 space-2--lg">
                <!-- Filter -->
                <ul id="filterControls" class="list-inline cbp-l-filters-alignCenter mb-5">

                  <li class="list-inline-item cbp-filter-item cbp-filter-item-active u-cubeportfolio__item"
                        data-filter=".abstract">Salón Principal</li>

                    <li class="list-inline-item cbp-filter-item u-cubeportfolio__item" data-filter=".branding">Salón
                        Pequeño</li>

                </ul>
                <!-- End Filter -->

                <!-- Content -->
                <div responsive-mode class="cbp" data-layout="grid" data-controls="#filterControls"
                    data-animation="quicksand" data-caption-animation="zoom" data-x-gap="15" data-y-gap="15"
                    data-load-more-selector="#cubeLoadMore" data-load-more-action="auto" data-load-items-amount="1"
                    data-media-queries='[
              {"width": 1500, "cols": 5},
              {"width": 1500, "cols": 5},
              {"width": 1500, "cols": 5},
              {"width": 1500, "cols": 5},
              {"width": 1500, "cols": 5}
            ]'>




                    <!-- Ingresando recorido de las mesas-->

                    <div class="row">


                        <?php
$query_select = mysqli_query($con, "SELECT * FROM mesa where locacion_idlocacion = 1 ");




while ($row = mysqli_fetch_array($query_select)) {
    $idmesa = $row['idmesa'];
    $numero = $row['numero'];
    $descripcion = $row['descripcion'];
    $estado = $row['estado'];

        
?>
                        <!-- Item -->
                        <div class="cbp-item abstract">

                            <a class="cbp-caption " href="platillos.php?idmesa=<?php echo $idmesa;?>">
                                <div class="cbp-caption-defaultWrap">
                                    <?php if ($estado == 'DISPONIBLE') {
                                    ?>

                                    <img src="../img/tables.svg" alt="Image Description">
                                    <div class="w-100 text-center content-centered-y p-3">
                                        <font face="Comic Sans MS,arial,verdana" size=10 color="#11324D">
                                            <?php echo $numero?></font>
                                    </div>
                                </div>
                                <div class="cbp-caption-activeWrap">
                                    <div class="w-100 text-center content-centered-y p-3">
                                        <font face="Comic Sans MS,arial,verdana" size=8 color="#11324D">
                                            <?php echo $numero?></font>
                                    </div>
                                </div>
                            </a>
                            <?php                                                   
                                } else { ?>

                            <img src="../img/not-working.svg" alt="Image Description">
                            <div class="w-100 text-center content-centered-y p-3">
                                <font face="Comic Sans MS,arial,verdana" size=10 color="#F8EDED"><?php echo $numero?>
                                </font>
                            </div>
                        </div>
                        <div class="cbp-caption-activeWrap">
                            <div class="w-100 text-center content-centered-y p-3">
                                <font face="Comic Sans MS,arial,verdana" size=8 color="#005792"><?php echo $numero?>
                                </font>
                            </div>
                        </div>
                        </a>


                        <?php }?>

                        <div class="p-4">
                            <h2 class="h5 mb-0 text-center"><strong><?php echo $descripcion?></strong></h2>

                        </div>

                    </div>
                    <?php
}
?>




                    <?php
                $query_select = mysqli_query($con, "SELECT * FROM mesa where locacion_idlocacion = 2 ");

                while ($row = mysqli_fetch_array($query_select)) {
                    $idmesa = $row['idmesa'];
                    $numero = $row['numero'];
                    $descripcion = $row['descripcion'];
                      $estado = $row['estado'];
                        ?>





                    <!-- Item -->
                    <div class="cbp-item branding">
                        <a class="cbp-caption" href="platillos.php?idmesa=<?php echo $idmesa;?>">
                            <div class="cbp-caption-defaultWrap">
                                <?php if ($estado == 'DISPONIBLE') {
                                    ?>
                                <img src="../img/table.svg" alt="Image Description">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=10 color="#FF2626">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                            <div class="cbp-caption-activeWrap">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=8 color="#005792">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                        </a>



                        <?php
                                } else { ?>


                        <img src="../img/not-working.svg" alt="Image Description">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=10 color="#F8EDED">
                                <?php echo $numero?></font>
                        </div>
                    </div>
                    <div class="cbp-caption-activeWrap">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=8 color="#005792"><?php echo $numero?>
                            </font>
                        </div>
                    </div>
                    </a>


                    <?php }?>

                    <div class="p-4">
                        <h2 class="h5 mb-0 text-center"><strong><?php echo $descripcion?></strong></h2>

                    </div>


                </div>
                <!-- End Item -->



                <?php
}
?>








<?php
                $query_select = mysqli_query($con, "SELECT * FROM mesa where locacion_idlocacion = 5 ");

                while ($row = mysqli_fetch_array($query_select)) {
                    $idmesa = $row['idmesa'];
                    $numero = $row['numero'];
                    $descripcion = $row['descripcion'];
                      $estado = $row['estado'];
                        ?>





                    <!-- Item -->
                    <div class="cbp-item bring">
                        <a class="cbp-caption" href="platillos.php?idmesa=<?php echo $idmesa;?>">
                            <div class="cbp-caption-defaultWrap">
                                <?php if ($estado == 'DISPONIBLE') {
                                    ?>
                                <img src="../img/salon-cuatro.svg" alt="Image Description">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=10 color="#FF2626">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                            <div class="cbp-caption-activeWrap">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=8 color="#005792">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                        </a>



                        <?php
                                } else { ?>


                        <img src="../img/not-working.svg" alt="Image Description">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=10 color="#F8EDED">
                                <?php echo $numero?></font>
                        </div>
                    </div>
                    <div class="cbp-caption-activeWrap">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=8 color="#005792"><?php echo $numero?>
                            </font>
                        </div>
                    </div>
                    </a>


                    <?php }?>

                    <div class="p-4">
                        <h2 class="h5 mb-0 text-center"><strong><?php echo $descripcion?></strong></h2>

                    </div>


                </div>
                <!-- End Item -->



                <?php
}
?>



<?php
                $query_select = mysqli_query($con, "SELECT * FROM mesa where locacion_idlocacion = 6 ");

                while ($row = mysqli_fetch_array($query_select)) {
                    $idmesa = $row['idmesa'];
                    $numero = $row['numero'];
                    $descripcion = $row['descripcion'];
                      $estado = $row['estado'];
                        ?>





                    <!-- Item -->
                    <div class="cbp-item brong">
                        <a class="cbp-caption" href="platillos.php?idmesa=<?php echo $idmesa;?>">
                            <div class="cbp-caption-defaultWrap">
                                <?php if ($estado == 'DISPONIBLE') {
                                    ?>
                                <img src="../img/restaurant(9).svg" alt="Image Description">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=10 color="#FF2626">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                            <div class="cbp-caption-activeWrap">
                                <div class="w-100 text-center content-centered-y p-3">
                                    <font face="Comic Sans MS,arial,verdana" size=8 color="#005792">
                                        <?php echo $numero?></font>
                                </div>
                            </div>
                        </a>



                        <?php
                                } else { ?>


                        <img src="../img/not-working.svg" alt="Image Description">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=10 color="#F8EDED">
                                <?php echo $numero?></font>
                        </div>
                    </div>
                    <div class="cbp-caption-activeWrap">
                        <div class="w-100 text-center content-centered-y p-3">
                            <font face="Comic Sans MS,arial,verdana" size=8 color="#005792"><?php echo $numero?>
                            </font>
                        </div>
                    </div>
                    </a>


                    <?php }?>

                    <div class="p-4">
                        <h2 class="h5 mb-0 text-center"><strong><?php echo $descripcion?></strong></h2>

                    </div>


                </div>
                <!-- End Item -->



                <?php
}
?>



            </div>
        </div>
        <!-- End Services Content -->


        </div>
        <!-- End Specialty Content -->
    </main>
    <!-- ========== END MAIN CONTENT ========== -->





    <!-- ========== ARCHIVOS NECESARIOS PARA EL FUNCIONAMIENTO ========== -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>
    <!-- End Go to Top -->

    <!-- JS Global Compulsory -->
    <script src="../../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="../../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="../../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="../../assets/vendor/bootstrap/bootstrap.min.js"></script>

    <!-- JS Implementing Plugins -->
    <script src="../../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="../../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js">
    </script>
    <script src="../../assets/vendor/custombox/dist/custombox.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.legacy.min.js"></script>
    <script src="../../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="../../assets/vendor/dzsparallaxer/dzsparallaxer.js"></script>
    <script src="../../assets/vendor/cubeportfolio/js/jquery.cubeportfolio.min.js"></script>
    <script src="../../assets/vendor/player.js/dist/player.min.js"></script>

    <!-- JS Space -->
    <script src="../../assets/js/hs.core.js"></script>
    <script src="../../assets/js/components/hs.header.js"></script>
    <script src="../../assets/js/components/hs.unfold.js"></script>
    <script src="../../assets/js/components/hs.validation.js"></script>
    <script src="../../assets/js/helpers/hs.focus-state.js"></script>
    <script src="../../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="../../assets/js/components/hs.modal-window.js"></script>
    <script src="../../assets/js/components/hs.show-animation.js"></script>
    <script src="../../assets/js/components/hs.slick-carousel.js"></script>
    <script src="../../assets/js/components/hs.cubeportfolio.js"></script>
    <script src="../../assets/js/components/hs.video-player.js"></script>
    <script src="../../assets/js/components/hs.go-to.js"></script>

    <!-- JS Plugins Init. -->
    <script>
    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of cubeportfolio
        $.HSCore.components.HSCubeportfolio.init('.cbp');

        // initialization of video player
        $.HSCore.components.HSVideoPlayer.init('.js-inline-video-player');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>
    <!-- ========== FIN DE ARCHIVOS NECESARIOS ========== -->
</body>

</html>