<?php
session_start();

require_once("../config/db.php"); //Contiene las variables de configuracion para conectar a la base de datos
require_once("../config/conexion.php"); //Contiene funcion que conecta a la base de datos
include("encabezado.php");

?>

<!DOCTYPE html>

<html lang="es">

<head>
    <!-- Title -->
    <title>MAHVICK</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" href="../img/cotzic.png">

    <!-- Google Fonts -->
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="../../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="../../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="../../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="../../assets/vendor/slick-carousel/slick/slick.css">
    <link rel="stylesheet" href="../../assets/vendor/dzsparallaxer/dzsparallaxer.css">
    <link rel="stylesheet" href="../../assets/vendor/cubeportfolio/css/cubeportfolio.min.css">

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="../../assets/css/theme.css">
</head>


<body class="responsive-mode">
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">
        <div class="container">
            <span class="u-skiplink-text">Skip to main content</span>
        </div>
    </a>
    <!-- End Skippy -->
    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">

        <!-- Services Content -->
        <div id="servicesSection" class="container space-2 space-2-top--lg space-2-bottom--lg">
            <div class="text-center">
                <br>
                <a aria-label="Space">
                    <img class="mb-3" src="../img/negro.png" alt="Logo" width="270" height="190">
                </a>
            </div>
            <p class="mb-0"></p>
            <div class="card-deck d-block d-lg-flex card-lg-gutters-1">
                <div class="card card-frame mb-7 animated bounceIn">
                    <!-- Listing -->
                    <a class="card-body p-4" href="mesas.php">
                        <div class="media">
                            <img class="max-width-12 mb-2 animated rubberBand" src="../img/food-tray.svg"
                                alt="Image Description">
                            <div class="media-body px-3">
                                <h4 class="h6 text-dark mb-2">Ordenar</h4>
                                <p class="mb-0">Orden para Servir</p>
                            </div>
                        </div>
                    </a>
                    <!-- End Listing -->
                </div>

                <div class="card card-frame mb-7 animated bounceIn">
                    <!-- Listing -->
                    <a class="card-body p-4" href="ordenFuera.php">
                        <div class="media">
                            <img class="max-width-12 mb-2 animated rubberBand" src="../img/food-delivery.svg"
                                alt="Image Description">
                            <div class="media-body px-3">
                                <h4 class="h6 text-dark mb-2">Orden Fuera</h4>
                                <p class="mb-0">Orden para Llevar o A Domicilio</p>
                            </div>
                        </div>
                    </a>
                    <!-- End Listing -->
                </div>



                <div class="card card-frame mb-7 animated bounceIn">
                    <!-- Listing -->
                    <a class="card-body p-4" href="mesascobrar.php">
                        <div class="media">
                            <img class="max-width-12 mb-2 animated rubberBand" src="../img/budget.svg"
                                alt="Image Description">
                            <div class="media-body px-3">
                                <h4 class="h6 text-dark mb-2">Pre-Cuenta</h4>
                                <p class="mb-0">Pre-Cuenta de Mesa</p>
                            </div>
                        </div>
                    </a>
                    <!-- End Listing -->
                </div>


            </div>
            <!-- End Services Content -->



            <!-- End Specialty Content -->
    </main>
    <!-- ========== END MAIN CONTENT ========== -->





    <!-- ========== ARCHIVOS NECESARIOS PARA EL FUNCIONAMIENTO ========== -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>
    <!-- End Go to Top -->

    <!-- JS Global Compulsory -->
    <script src="../../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="../../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="../../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="../../assets/vendor/bootstrap/bootstrap.min.js"></script>

    <!-- JS Implementing Plugins -->
    <script src="../../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="../../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.legacy.min.js"></script>
    <script src="../../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="../../assets/vendor/dzsparallaxer/dzsparallaxer.js"></script>
    <script src="../../assets/vendor/cubeportfolio/js/jquery.cubeportfolio.min.js"></script>
    <script src="../../assets/vendor/player.js/dist/player.min.js"></script>

    <!-- JS Space -->
    <script src="../../assets/js/hs.core.js"></script>
    <script src="../../assets/js/components/hs.header.js"></script>
    <script src="../../assets/js/components/hs.unfold.js"></script>
    <script src="../../assets/js/components/hs.validation.js"></script>
    <script src="../../assets/js/helpers/hs.focus-state.js"></script>
    <script src="../../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="../../assets/js/components/hs.modal-window.js"></script>
    <script src="../../assets/js/components/hs.show-animation.js"></script>
    <script src="../../assets/js/components/hs.slick-carousel.js"></script>
    <script src="../../assets/js/components/hs.cubeportfolio.js"></script>
    <script src="../../assets/js/components/hs.video-player.js"></script>
    <script src="../../assets/js/components/hs.go-to.js"></script>

    <!-- JS Plugins Init. -->
    <script>
    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of cubeportfolio
        $.HSCore.components.HSCubeportfolio.init('.cbp');

        // initialization of video player
        $.HSCore.components.HSVideoPlayer.init('.js-inline-video-player');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>
    <!-- ========== FIN DE ARCHIVOS NECESARIOS ========== -->
</body>

</html>