<?php
// checking for minimum PHP version

use FontLib\Table\Type\head;



// include the configs / constants for the database connection
require_once("config/db.php");

// load the login class
require_once("classes/Login.php");

// create a login object. when this object is created, it will do all login/logout stuff automatically
// so this single line handles the entire login process. in consequence, you can simply ...
$login = new Login();

// ... ask if we are logged in here:
if ($login->isUserLoggedIn() == true) {
    // the user is logged in. you can do whatever you want here.
    // for demonstration purposes, we simply show the "you are logged in" view.
    include("classes/sessiones.php");

} else {
    
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <!-- Title -->
    <title>MAHVICK</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
  <link rel="shortcut icon" href="../img/negro.png">

    <!-- Google Fonts -->
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500%7CCharm" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="./../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="./../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="./../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="./../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="./../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="./../assets/vendor/slick-carousel/slick/slick.css">

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="./../assets/css/theme.css">
</head>

<body>
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">

    </a>
    <!-- End Skippy -->

    <!-- ========== HEADER ========== -->
    <header id="header"
        class="u-header u-header--modern u-header--bordered u-header--bg-transparent u-header--white-nav-links u-header--sticky-top-lg">
        <div class="u-header__section">
            <div id="logoAndNav" class="container-fluid">
                <!-- Nav -->
                <nav class="js-mega-menu navbar navbar-expand-lg u-header__navbar">
                    <!-- Logo -->
                    <div class="u-header__navbar-brand-wrapper">
                        <a class="navbar-brand u-header__navbar-brand" aria-label="Genesis">
                            <img class="u-header__navbar-brand-default" src="img/negro.png" width="85"
                                height="60" alt="Logo">
                            <img class="u-header__navbar-brand-mobile" src="img/negro.png" alt="Logo">
                        </a>
                    </div>
                    <!-- End Logo -->

                    <!-- Responsive Toggle Button -->
                    <button type="button" class="navbar-toggler btn u-hamburger u-header__hamburger"
                        aria-label="Toggle navigation" aria-expanded="false" aria-controls="navBar"
                        data-toggle="collapse" data-target="#navBar">
                        <span class="d-none d-sm-inline-block">Menu</span>
                        <span id="hamburgerTrigger" class="u-hamburger__box ml-3">
                            <span class="u-hamburger__inner"></span>
                        </span>
                    </button>
                    <!-- End Responsive Toggle Button -->

                    <!-- Navigation -->
                    <div id="navBar" class="collapse navbar-collapse u-header__navbar-collapse py-0">
                        <ul class="navbar-nav u-header__navbar-nav">

                            <!-- Button -->
                            <li class="nav-item u-header__nav-item-btn">
                                <a class="btn btn-green btn-xs rounded-0 text-uppercase" href="#signupModal"
                                    role="button" data-modal-target="#signupModal" data-overlay-color="#151b26">
                                    <span class="fa fa-sign-in-alt mr-1"></span>
                                    Ingresar
                                </a>

                            </li>
                            <!-- End Button -->
                        </ul>
                    </div>
                    <!-- End Navigation -->

                    <ul class="navbar-nav flex-row u-header__secondary-nav">



                    </ul>
                </nav>
                <!-- End Nav -->
            </div>
        </div>
    </header>
    <!-- ========== END HEADER ========== -->

    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">
        <div class="d-md-flex align-items-md-center height-100vh--lg gradient-overlay-half-dark-v1 bg-img-hero"
            style="background-image: url(img/portada.JPG );">
            <div class="container space-1 space-1--md text-center">
                <div class="w-md-20 w-lg-20 mt-lg-9 mx-md-auto">
                    <div class="mb-6">

                    </div>


                </div>
            </div>
        </div>

    </main>
    <!-- ========== END MAIN CONTENT ========== -->


    <!-- Signup Modal Window -->
    <div id="signupModal" class="js-signup-modal u-modal-window" style="width: 500px;">
        <!-- Modal Close Button -->
        <button class="btn btn-sm btn-icon btn-text-secondary u-modal-window__close" type="button"
            onclick="Custombox.modal.close();">
            <span class="fas fa-times"></span>
        </button>
        <!-- End Modal Close Button -->

        <!-- Content -->
        <div class="p-5">
            <form method="post" accept-charset="utf-8" action="index.php" name="loginform" autocomplete="off"
                role="form" class="form-signin">
                <!-- Signin -->
                <div id="signin" data-target-group="idForm">
                    <!-- Title -->
                    <header class="text-center mb-5">
                        <h2 class="h4 mb-0">Inicia sesion con tu cuenta</h2>

                    </header>
                    <!-- End Title -->

                    <!-- Input -->
                    <div class="js-form-message mb-3">
                        <div class="js-focus-state input-group form">
                            <div class="input-group-prepend form__prepend">
                                <span class="input-group-text form__text">
                                    <span class="fa fa-user form__text-inner"></span>
                                </span>
                            </div>
                            <input type="text" class="form-control form__input" name="username" required
                                placeholder="Usuario" aria-label="Usuario" data-msg="Tu usuario no es valido"
                                data-error-class="u-has-error" data-success-class="u-has-success">
                        </div>
                    </div>
                    <!-- End Input -->

                    <!-- Input -->
                    <div class="js-form-message mb-3">
                        <div class="js-focus-state input-group form">
                            <div class="input-group-prepend form__prepend">
                                <span class="input-group-text form__text">
                                    <span class="fa fa-lock form__text-inner"></span>
                                </span>
                            </div>
                            <input type="password" class="form-control form__input" name="password" required
                                placeholder="Contraseña" aria-label="Password" data-msg="Tu contraseña es invalida"
                                data-error-class="u-has-error" data-success-class="u-has-success">
                        </div>
                    </div>
                    <!-- End Input -->

                    <input type="text" name="action" id="action" value="login" style="visibility:hidden;">

                </div>
                <div class="d-sm-flex justify-content-sm-center align-items-sm-center">
                    <button type="submit" class="btn btn-green" name="login"
                        id="submit">Iniciar Sesión</button>

                </div>

                <!-- Divider -->

                <!-- End Divider -->

                <!-- Signin Social Buttons -->

                <!-- End Signin Social Buttons -->
        </div>

        </form>
    </div>
    <!-- End Signup Modal Window -->
    <!-- ========== END SECONDARY CONTENTS ========== -->

    <!-- Go to Top -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>
    <!-- End Go to Top -->


    <script type="text/javascript" src="jshome/jquery.min.js"> </script>
    <script type="text/javascript" src="jshome/sesiones.js"> </script>
    <script type="text/javascript" src="jshome/bootstrap.min.js"> </script>
    <!-- JS Global Compulsory -->
    <script src="./../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="./../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="./../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="./../assets/vendor/bootstrap/bootstrap.min.js"></script>





    <!-- JS Implementing Plugins -->
    <script src="./../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="./../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="./../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="./../assets/vendor/custombox/dist/custombox.min.js"></script>
    <script src="./../assets/vendor/custombox/dist/custombox.legacy.min.js"></script>
    <script src="./../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="./../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="./../assets/vendor/gmaps/gmaps.min.js"></script>

    <!-- JS Space -->
    <script src="./../assets/js/hs.core.js"></script>
    <script src="./../assets/js/components/hs.header.js"></script>
    <script src="./../assets/js/components/hs.unfold.js"></script>
    <script src="./../assets/js/components/hs.validation.js"></script>
    <script src="./../assets/js/helpers/hs.focus-state.js"></script>
    <script src="./../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="./../assets/js/components/hs.modal-window.js"></script>
    <script src="./../assets/js/components/hs.show-animation.js"></script>
    <script src="./../assets/js/components/hs.slick-carousel.js"></script>
    <script src="./../assets/js/components/hs.g-map.js"></script>
    <script src="./../assets/js/components/hs.go-to.js"></script>

    <!-- JS Plugins Init. -->
    <script>
    // initialization of google map
    function initMap() {
        $.HSCore.components.HSGMap.init('.js-g-map');
    }

    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABAaQLTeSRRn4egPXc1tRNi40scrXvcQM&callback=initMap"
        async defer></script>
</body>

</html>

<?php
}


?>