<?php
session_start();
require_once("../config/db.php"); //Contiene las variables de configuracion para conectar a la base de datos
require_once("../config/conexion.php"); //Contiene funcion que conecta a la base de datos

include("encabezado.php");

// consulta para llenar tabla 

?>

<!DOCTYPE html>

<html lang="es">

<head>
    <!-- Title -->
    <title>COTZIC</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" href="../img/cotzic.png">

    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="../../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="../../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="../../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="../../assets/vendor/slick-carousel/slick/slick.css">
    <link rel="stylesheet" href="../../assets/vendor/dzsparallaxer/dzsparallaxer.css">
    <link rel="stylesheet" href="../../assets/vendor/cubeportfolio/css/cubeportfolio.min.css">

    <script src="js/plotly-latest.min.js"></script>

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="../../assets/css/theme.css">
</head>

<body class="responsive-mode">
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">
        <div class="container">
            <span class="u-skiplink-text">Skip to main content</span>
        </div>
    </a>
    <!-- End Skippy -->

    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">
        <div class="container space-2 space-3-top--lg space-2-bottom--lg">


            <div class="col-lg-12 order-lg-1">


                <!-- Step Form Content -->
                <div id="stepFormContent">
                    <!-- Customer Info -->
                    <div id="newmedida" class="active">

                        <!-- Billing Form -->


                        <div class="modal-body">

                            <!-- Checkout Form -->

                            <!-- Step Form Header -->
                            <ul id="stepFormProgress"
                                class="js-step-progress list-inline u-shopping-cart-step-form mb-4">
                                <!-- Step Form Item -->
                                <li class="list-inline-item u-shopping-cart-step-form__item mb-3">

                                    <span class="u-shopping-cart-step-form__title">
                                        <H4 align="center"><strong> SALON MAS RESERVADO </strong></H4>
                                    </span>
                                    <!-- titulo del formulario en texto-->
                                </li>
                            </ul>
                            <!-- End Step Form Header -->

                            <!-- Step Form Content -->
                            <div id="stepFormContent">

                                <div id="insertarMedida" class="active">

                                    <form action="#" method="POST">

                                        <!-- Billing Form -->
                                        <div class="row">
                          

                                            <div class="col-md-3">
                                                <div class="mb-6">
                                                    <label class="h6 small d-block text-uppercase">
                                                        MES
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-control input-sm" name="mes" id="mes">

                                                        <option value="0" disabled="true" selected="selected">
                                                            Seleccionar</option>
                                                        <option value="1">ENERO</option>
                                                        <option value="2">FEBRERO</option>
                                                        <option value="3">MARZO</option>
                                                        <option value="4">ABRIL</option>
                                                        <option value="5">MAYO</option>
                                                        <option value="6">JUNIO</option>
                                                        <option value="7">JULIO</option>
                                                        <option value="8">AGOSTO</option>
                                                        <option value="9">SEPTIEMBRE</option>
                                                        <option value="10">OCTUBRE</option>
                                                        <option value="11">NOVIEMBRE</option>
                                                        <option value="12">DICIEMBRE</option>
                                                    </select>
                                                </div>


                                            </div>



                                            <div class="col-md-3">
                                                <div class="mb-6">
                                                    <label class="h6 small d-block text-uppercase">
                                                        AÑO
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-control input-sm" name="anio" id="anio">

                                                        <option value="0" disabled="true" selected="selected">
                                                            Seleccionar</option>
                                                        <option value="2022">2022</option>
                                                        <option value="2023">2023</option>
                                                        <option value="2024">2024</option>
                                                        <option value="2025">2025</option>

                                                    </select>
                                                </div>


                                            </div>





                                            <div class="col-md-3">
                                                <div class="mb-6">
                                                    <label class="h6 small d-block text-uppercase">
                                                        Acciones
                                                        <span class="text-danger">*</span>
                                                    </label>

                                                    <div>


                                                        <input type="submit" class="btn btn-success text-center"
                                                            data-next-step="agregar" value="Buscar" name="busqueda"
                                                            id="busqueda">
                                                    </div>


                                                </div>

                                            </div>

                                    </form>

                                    <?php
                                    if ($_POST) {
                                        $mes = $_POST['mes'];
                                        $anio = $_POST['anio'];

                                    ?>
            
                                    <div id="myTabContent" class="col-lg-12 col-md-12 col-sm-12 col-xs-12"
                                        class="tab-content-center d-flex justify-content-center ">
                                        <table class="table  table-condensed table-hover table-responsive-md  justify-center "
                                            id="tablaFecha">
                                            <thead>
                                                <tr class="bgcolor btn-green">

                                                   
                                                    <th class="text-center">#</th>
                                                    <th class="text-center">Salones</th>
                                                    <th class="text-center">No. De Reservaciones</th>


                                                </tr>
                                            </thead>

                                            <tbody>

                                                <?php




                                                    $valoresY = array();
                                                    $valoresX = array();
                                                    $numero = 0;
                                                    $costo = 0;
                                                    $total = 0;

                                                    $query_select = mysqli_query($con, "SELECT SUM(r.total) AS total, l.nombre, COUNT(r.locacion_idlocacion) reservaciones FROM reservacion r
                                                    INNER JOIN locacion l ON l.idlocacion = r.locacion_idlocacion
                                                    WHERE MONTH(r.fechapago) = '$mes' AND YEAR(r.fechapago) ='$anio' AND r.estado = 'PAGADO' GROUP BY r.locacion_idlocacion ORDER BY total DESC");
                                                    $num_rows = mysqli_num_rows($query_select);

                                                    if ($num_rows > 0 ) {

                                                        $totales = 0;
                                                                                                               while ($row = mysqli_fetch_assoc($query_select)) {
                                                       
                                                                                                                   $total = $row['total'];
                                                                                                                   $venta = $row['reservaciones'];
                                                                                                                   $nombres = $row['nombre'];
                                                                                                                   $totales += $total;
                                                                                                                   $numero++;
                                                                                                                   
                                                       
                                                                                                                   $valoresY[] = $row['total'];
                                                                                                                   $valoresX[] = $numero . ') ' . $row['nombre'];
                                                       
                                                                                                                   $datosX = json_encode($valoresX);
                                                                                                                   $datosY = json_encode($valoresY);
                                                       
                                                                                                           ?>
                                                                                                       <tr>
                                                                                                           <td class="text-center"><?php echo  $numero ?></td>
                                                                                                           <td class="text-center"><?php echo  $nombres ?></td>
                                                                                                           <td class="text-center"><?php echo  $venta  ?></td>
                                                                                                           
                                                       
                                                                                                           <?php
                                                       
                                                        
                                                                                                               }
                                                                                                                   ?>
                                                       
                                                       
                                                                                                           <?php
                                                                                                                   
                                                                                                                 
                                                                                                                   $ventasTotales = number_format($totales, 2, ".", ",");
                                                                                                                  
                                                                                                                   echo "<h4 align='center'><strong>SALON MAS RESERVADO DEL MES $mes - $anio</h4>";
                                                                                                                 
                                                                                                                   ?>
                                                       
                                                       
                                                       
                                                                                                   </tbody>
                                                                                               </table>



                                        <div id="graficaCircular"></div>
                                        <div id="graficaLineal"></div>
                                    </div>






                                </div>

                            </div>

                        </div>





                        </nav>

                    </div>

                    <?php

                                                    } else {

                ?> <H4 align="center"><strong>NO EXISTEN DATOS REGISTRADOS PARA ESTA FECHA</strong> </H4> <?php

                                                                                                        }
                                                                                                    }

                                                                                                            ?>




                </div>




    </main>

    <!-- ========== END MAIN CONTENT ========== -->

    <!-- ========== LLama a ventanas Modales ========== -->




    <!-- ========== ARCHIVOS NECESARIOS PARA EL FUNCIONAMIENTO ========== -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>



    <script type="text/javascript">
    function cadenaGrafico(json) {
        var parsed = JSON.parse(json);
        var arr = [];
        for (var x in parsed) {
            arr.push(parsed[x]);
        }
        return arr;

    }
    </script>

    <script type="text/javascript">
    datosX = cadenaGrafico('<?php echo $datosX ?>');
    datosY = cadenaGrafico('<?php echo $datosY ?>');

    var data = [{
        type: "pie",
        values: datosY,
        labels: datosX,
        textinfo: "label+percent",
        insidetextorientation: "radial"
    }];

    var layout = {
        title: 'Salon Más Reservado en la fecha <?php echo $mes,'-',$anio ?> ',
        barmode: 'stack',
        font: {
            size: 15
        }


    };
    var config = {
        responsive: true
    }

    Plotly.newPlot('graficaCircular', data, layout, config)
    </script>


    <script type="text/javascript">
    datosX = cadenaGrafico('<?php echo $datosX ?>');
    datosY = cadenaGrafico('<?php echo $datosY ?>');


    var xValue = datosX

    var yValue = datosY;
    var trace1 = {
        x: xValue,
        y: yValue,
        type: 'bar',
        text: yValue.map(String),
        textposition: 'auto',
        hoverinfo: 'none',
        marker: {
            color: 'rgb(158,202,225)',
            opacity: 0.6,
            line: {
                color: 'rgb(8,48,107)',
                width: 1.5
            }
        }
    };

    var data = [trace1];

    var layout2 = {
        title: 'Salon Más Reservado en la fecha <?php echo $mes,'-',$anio ?> ',
        barmode: 'stack',
        font: {
            size: 15
        }
    };
    var config = {
        responsive: true
    }
    Plotly.newPlot('graficaLineal', data, layout2, config);
    </script>


    <!-- End Go to Top -->
    <script type="text/javascript" src="js/jquery.min.js"> </script>
    <script type="text/javascript" src="js/fecha.js"> </script>

    <!-- datatables JS -->
    <script type="text/javascript" src="datatables/datatables.min.js"></script>



    <!-- End Go to Top -->
    <script type="text/javascript" src="js/jquery.min.js"> </script>
    <script type="text/javascript" src="js/cierre.js"> </script>


    <!-- JS Global Compulsory -->
    <script src="../../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="../../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="../../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="../../assets/vendor/bootstrap/bootstrap.min.js"></script>

    <!-- JS Implementing Plugins -->
    <script src="../../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="../../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.min.js"></script>
    <script src="../../assets/vendor/custombox/dist/custombox.legacy.min.js"></script>
    <script src="../../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="../../assets/vendor/dzsparallaxer/dzsparallaxer.js"></script>
    <script src="../../assets/vendor/cubeportfolio/js/jquery.cubeportfolio.min.js"></script>
    <script src="../../assets/vendor/player.js/dist/player.min.js"></script>

    <!-- JS Space -->
    <script src="../../assets/js/hs.core.js"></script>
    <script src="../../assets/js/components/hs.header.js"></script>
    <script src="../../assets/js/components/hs.unfold.js"></script>
    <script src="../../assets/js/components/hs.validation.js"></script>
    <script src="../../assets/js/helpers/hs.focus-state.js"></script>
    <script src="../../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="../../assets/js/components/hs.modal-window.js"></script>
    <script src="../../assets/js/components/hs.show-animation.js"></script>
    <script src="../../assets/js/components/hs.slick-carousel.js"></script>
    <script src="../../assets/js/components/hs.cubeportfolio.js"></script>
    <script src="../../assets/js/components/hs.video-player.js"></script>
    <script src="../../assets/js/components/hs.go-to.js"></script>

    <!-- JS Plugins Init. -->
    <!-- Libreria DataTables para talbas -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.css" />
    <!-- <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>-->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.js"></script>

    <!-- End Skippy -->
    <script>
    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of cubeportfolio
        $.HSCore.components.HSCubeportfolio.init('.cbp');

        // initialization of video player
        $.HSCore.components.HSVideoPlayer.init('.js-inline-video-player');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- ========== FIN DE ARCHIVOS NECESARIOS ========== -->

</body>

</html>