$(document).ready(() => {

    var tablaPlatillos = $('#tablaPlatillos').DataTable({

        "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "sProcessing": "Procesando...",
        }
    });




    //Insertar Platillos -->

    $('#Insertar_platillo').submit(function (event) {



        var parametros = new FormData($('#Insertar_platillo')[0])
        $.ajax({
            type: 'POST',
            url: './ajax/ajaxPlatilloEvento.php',
            data: parametros,
            contentType: false,
            processData: false,

            beforeSend: function name(params) {

            },
            success: response => {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Platillo de Evento Insertado Correctamente",
                        icon: 'success',
                        showConfirmButton: false,
                        timer: 350
                    }).then(function () {

                        location.reload();

                    });

                }


                if (response == 'replica') {

                    Swal.fire({
                        title: "Platillo ya existente",
                        icon: 'warning',
                    }).then(function () {

                        location.reload();

                    });

                }



            }

        });
        event.preventDefault();
    });







    $("#nuevo_Platillo").click(event => {

        event.preventDefault();

        window.location = "nuevoPlatillo.php";


    });





    // End Ready

});






function editarPlatillo() {

    var parametros = new FormData($('#Actualizar_Platillo')[0])
    $.ajax({
        type: "POST",
        url: './ajax/ajaxPlatilloEvento.php',
        data: parametros,
        contentType: false,
        processData: false,
        beforeSend: function () {

        },
        success: response => {
            if (response == 'successful') {
                Swal.fire({
                    title: "Platillo Actualizado Correctamente",
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 350

                }).then(function () {
                    $('#Modal_Editar_Platillos').modal("toggle");
                    location.reload();

                });


            }

        }




    });


    event.preventDefault();


}


// Obtiene los datos necesarios para editar el modal de edicion.
function obtener_datos_editar(idPlatillo) {
    var action = 'obtener_datos';
    var id_Platillo = idPlatillo;

    $.ajax({
        url: './ajax/ajaxPlatilloEvento.php',
        type: "POST",
        async: true,
        data: { action: action, id_Platillo: id_Platillo },
        success: function (response) {
            if (response != 'error') {

                var info = JSON.parse(response);


                $('#id_Platillo2').val(info.idmenu);
                $('#nombre2').val(info.nombre);
                $('#descripcion2').val(info.descripcion);
                $('#clasificacion2').val(info.clasificaciones_idclasificaciones);
                $('#precio2').val(info.precio);





            } else {

                console.log("No existen datos")

            }

        },
        error: error => {
            console.log(error);
        }

    });

}

//Cambiar el estado del producto




let estado_Platillo = id => {
    var action = 'estado_Platillo';
    var id = id;

    $.ajax({
        type: 'POST',
        url: './ajax/ajaxPlatilloEvento.php',
        data: { action: action, id: id },
        beforeSend: function () {

        },
        success: function (response) {
            if (response == 'successful') {
                Swal.fire({
                    title: "Estado Actualizado Correctamente",
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 350
                }).then(function () {
                    //      $('#Modal_Editar_Platillos').modal("toggle");
                    location.reload();

                });


            }

        }


    });

}