//Código para Datables

//$('#example').DataTable(); //Para inicializar datatables de la manera más simple

$(document).ready(function() {

    gastos = $('#tablaGastos').DataTable({

        "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "sProcessing": "Procesando...",
        }


    });



        //Editar 

        $("#Actualizar_Gasto").submit(function(event) {
            $('#guardar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: './ajax/ajaxGasto.php',
                data: parametros,
                beforeSend: function(objeto) {
    
                },
                success: function(response) {
                    if (response = 'successful') {
                        Swal.fire({
                            title: "Gasto Actualizado Correctamente",
                            icon: 'success',
                        }).then(function() {
    
                            location.reload();
    
                        });
    
    
    
    
    
    
                    }
    
                }
    
            });
    
            event.preventDefault();
        });
    
    



    //Insertar Gasto

    $("#Insertar_Gasto").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxGasto.php',
            data: parametros,
            beforeSend: function(objeto) {

            },
            success: function(response) {
                if (response = 'successful') {
                    Swal.fire({
                        title: "Tipo de Gasto Insertado Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });






                }

            }

        });

        event.preventDefault();
    });



    //Agregar descripcion de gastos

    $("#Agregar_Gasto").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxGasto.php',
            data: parametros,
            beforeSend: function name(params) {

            },
            success: response => {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Gasto Insertado Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });

                }


            }

        });

        event.preventDefault();
    });







});



$("#nueva_Mesa").click(event => {

    event.preventDefault();

    window.location = "nuevoGasto.php";


});




// Obtiene los datos necesarios para editar el modal de edicion.

function obtener_datos_editar(id_gasto) {
    var action = 'obtener_datos';
    var id_gasto = id_gasto;

    $.ajax({
        url: './ajax/ajaxGasto.php',
        type: "POST",
        async: true,
        data: { action: action, id_gasto: id_gasto },
        success: function(response) {
            if (response != 'error') {

                var info = JSON.parse(response);
                $('#id_gasto2').val(info.idgasto);
                $('#nombres2').val(info.descripcion);
                $('#monto2').val(info.monto);
                $('#fecha2').val(info.fecha);
                $('#gasto2').val(info.tipogasto_idtipogasto);

            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}




// Anular Gasto

function anular(idgasto) {
    var action = 'anular';
    var id_gasto = idgasto;

    $.ajax({
        url: './ajax/ajaxGasto.php',
        type: "POST",
        async: true,
        data: { action: action, id_gasto: id_gasto },
        success: function(response) {
            if (response = 'successful') {

                Swal.fire({
                    title: " Gasto Anulado Correctamente",
                    icon: 'success',
                }).then(function() {

                    location.reload();


                });





            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}











//eliminar

function eliminar(idgasto) {

    var idgasto = idgasto;

    action = 'eliminarGasto'

    $.ajax({
        url: './ajax/ajaxConfig_Gasto.php',
        type: "POST",
        async: true,
        data: { action: action, idgasto: idgasto },
        success: function(response) {
            console.log(response);
            if (response == 'successfull') {
                Swal.fire({
                    title: "Gasto Eliminado Correctamente",
                    icon: 'success',
                    //showConfirmButton: false,
                    //timer: 800

                }).then(function() {


                    window.location = 'configGastos.php';

                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Algo salió Mal!',

                })

            }



        },
        error: function(error) {

        }

    });



}












function refrescar(tiempo) {
    //Cuando pase el tiempo elegido la página se refrescará 
    setTimeout("location.reload(true);", tiempo);
}





function generarPDF(idgasto) {
    var ancho = 1000;
    var alto = 800;
    // calcular posicion x,y para centrar la venta

    var x = parseInt((window.screen.width / 2) - (ancho / 2));
    var y = parseInt((window.screen.width / 2) - (alto / 2));

    $url = 'pdf/documentos/gasto_pdf.php?gasto=' + idgasto;
    window.open($url, "gasto", "left" + x + ",top=" + y + ",height" + alto + ",width" + ancho + ",scrollbar=si,location=no,resizable=si,menubar=no")
}



