<?php
session_start();
require_once("../config/db.php"); //Contiene las variables de configuracion para conectar a la base de datos
require_once("../config/conexion.php"); //Contiene funcion que conecta a la base de datos

include("encabezado.php");

// consulta para llenar tabla 

?>

<!DOCTYPE html>

<html lang="es">

<head>
    <!-- Title -->
    <title>MAHVICK</title>

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" href="../img/negro.png">

    <!-- Google Fonts -->
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500" rel="stylesheet">

    <!-- CSS Implementing Plugins -->
    <link rel="stylesheet" href="../../assets/vendor/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../../assets/vendor/hs-megamenu/src/hs.megamenu.css">
    <link rel="stylesheet" href="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.css">
    <link rel="stylesheet" href="../../assets/vendor/custombox/dist/custombox.min.css">
    <link rel="stylesheet" href="../../assets/vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="../../assets/vendor/slick-carousel/slick/slick.css">
    <link rel="stylesheet" href="../../assets/vendor/dzsparallaxer/dzsparallaxer.css">
    <link rel="stylesheet" href="../../assets/vendor/cubeportfolio/css/cubeportfolio.min.css">

    <!-- CSS Space Template -->
    <link rel="stylesheet" href="../../assets/css/theme.css">
</head>

<body class="responsive-mode">
    <!-- Skippy -->
    <a id="skippy" class="sr-only sr-only-focusable u-skippy" href="#content">
        <div class="container">
            <span class="u-skiplink-text">Skip to main content</span>
        </div>
    </a>
    <!-- End Skippy -->



    <!-- ========== MAIN CONTENT ========== -->
    <main id="content" role="main">
        <!-- Checkout Form Section -->
        <div class="container space-2 space-3-top--lg space-2-bottom--lg">
            <div class="row">
                <div class="col-lg-2 order-lg-3 mb-10 mb-lg-2">
                </div>
            </div>

            <div class="col-lg-12 order-lg-1">
                <!-- Checkout Form -->
                <form class="form-horizontal" method="post" id="Agregar_Gasto" name="Agregar_Gasto">

                    <!-- Step Form Header -->
                    <ul id="stepFormProgress" class="js-step-progress list-inline u-shopping-cart-step-form mb-4">
                        <!-- Step Form Item -->
                        <li class="list-inline-item u-shopping-cart-step-form__item mb-3">

                            <span class="u-shopping-cart-step-form__title text-dark">Nuevo Gasto</span>
                        </li>
                    </ul>
                    <!-- End Step Form Header -->


                    <div class="col-12 mb-5 ">
                        <nav class="navbar navbar-light ">

                            <div class="col-6 mb-1 " class="form-inline">
                                <input type="button" class="btn btn-secondary btn-md text-center" class="form-control "
                                    data-next-step="Crear" id="nuevo_Gasto" value="Nuevo Tipo de Gasto (+)"
                                    name="nuevo_Gasto" data-toggle="modal" data-target="#Modal_Nuevo_Gasto"></input>
                            </div>
                            <div class="col-6 " class="form-inline">

                            </div>
                        </nav>
                    </div>








                    <!-- Step Form Content -->
                    <div id="stepFormContent">
                        <!-- Customer Info -->
                        <div id="nuevagasto" class="active">

                            <!-- Billing Form -->
                            <div class="row">
                                <div class="col-md-6">
                                    <!-- Input -->
                                    <input type="text" name="empleado" id="empleado"
                                        value="<?php echo $_SESSION['user'] ?>" hidden>
                                    <div class="js-form-message mb-12">
                                        <label class="h12 small d-block text-uppercase">
                                            Descripcion
                                            <span class="text-danger">*</span>
                                        </label>

                                        <div class="js-focus-state input-group form">
                                            <input class="form-control form__input" type="text" name="descripcion"
                                                id="descripcion" required placeholder="Descripcion"
                                                data-msg="Descripcion." data-error-class="u-has-error"
                                                data-success-class="u-has-success">
                                        </div>
                                    </div>
                                    <!-- End Input -->
                                </div>



                                <div class="col-md-3">
                                    <!-- Input -->
                                    <div class="js-form-message mb-6">
                                        <label class="h6 small d-block text-uppercase">
                                            Monto
                                            <span class="text-danger">*</span>
                                        </label>

                                        <div class="js-focus-state input-group form">
                                            <input class="form-control form__input" type="number" name="monto"
                                                id="monto" min="0.00" placeholder="Monto" step="0.01">
                                        </div>
                                    </div>
                                    <!-- End Input -->
                                </div>

                                <div class="col-md-3">
                                    <div class="mb-6">
                                        <label class="h6 small d-block text-uppercase">
                                            Tipo de Gasto
                                            <span class="text-danger">*</span>
                                        </label>
                                        <select class="custom-select input-sm" name="tgasto" id="tgasto">

                                            <option value="0" disabled="true" selected="selected">
                                                Seleccionar</option>

                                            <?php

                                            $sql = "SELECT * FROM tipogasto";
                                            $res = mysqli_query($con, $sql);
                                            while ($data = mysqli_fetch_array($res)) {

                                                $d1 = $data['idtipogasto'];
                                                $d2 = $data['nombre'];

                                            ?>

                                            <option value="<?php echo $d1; ?>"> <?php echo $d2; ?>
                                            </option>
                                            <?php
                                            }
                                            ?>

                                        </select>
                                    </div>
                                    <!-- End Select -->
                                </div>


                            </div>
                            <!-- End Billing Form -->
                            <input type="text" name="action" id="action" value="agregar" hidden>
                            <input type="text" name="intencion" id="intencion" value="intencion" hidden>
                            <!-- Buttons -->
                            <div class="d-sm-flex justify-content-sm-center align-items-sm-center">


                                <input type="submit" class="btn btn-success text-center" data-next-step="agregar"
                                    value="Agregar" name="insertar"></input>


                </form>
                <!-- End Checkout Form -->
            </div>
        </div>
        </div>
        <!-- End Checkout Form Section -->
    </main>
    <!-- ========== END MAIN CONTENT ========== -->
    <!-- ========== FOOTER ========== -->
   
    <!-- ========== END FOOTER ========== -->

    <!-- Signup Modal Window -->
    <?php
    include("modal/CRUD_gastos.php"); // modal que permite Guardar el usuario
    // include("modal/modalAsesorAsociado.php") ;

    ?>
    <!-- End Signup Modal Window -->
    <!-- ========== END SECONDARY CONTENTS ========== -->

    <!-- Go to Top -->
    <a class="js-go-to u-go-to" href="javascript:;" data-position='{"bottom": 15, "right": 15 }' data-type="fixed"
        data-offset-top="400" data-compensation="#header" data-show-effect="slideInUp" data-hide-effect="slideOutDown">
        <span class="fa fa-arrow-up u-go-to__inner"></span>
    </a>
    <!-- End Go to Top -->

    <!-- JS Global Compulsory -->
    <script type="text/javascript" src="js/jquery.min.js"> </script>
    <script type="text/javascript" src="datatables/datatables.min.js"></script>
    <script src="js/gasto.js"></script>


    <!-- JS Global Compulsory -->
    <script src="../../assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="../../assets/vendor/jquery-migrate/dist/jquery-migrate.min.js"></script>
    <script src="../../assets/vendor/popper.js/dist/umd/popper.min.js"></script>
    <script src="../../assets/vendor/bootstrap/bootstrap.min.js"></script>

    <!-- JS Implementing Plugins -->
    <script src="../../assets/vendor/hs-megamenu/src/hs.megamenu.js"></script>
    <script src="../../assets/vendor/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="../../assets/vendor/malihu-custom-scrollbar-plugin/jquery.mCustomScrollbar.concat.min.js"></script>

    <script src="../../assets/vendor/slick-carousel/slick/slick.js"></script>
    <script src="../../assets/vendor/dzsparallaxer/dzsparallaxer.js"></script>
    <script src="../../assets/vendor/cubeportfolio/js/jquery.cubeportfolio.min.js"></script>
    <script src="../../assets/vendor/player.js/dist/player.min.js"></script>

    <!-- JS Space -->
    <script src="../../assets/js/hs.core.js"></script>
    <script src="../../assets/js/components/hs.header.js"></script>
    <script src="../../assets/js/components/hs.unfold.js"></script>
    <script src="../../assets/js/components/hs.validation.js"></script>
    <script src="../../assets/js/helpers/hs.focus-state.js"></script>
    <script src="../../assets/js/components/hs.malihu-scrollbar.js"></script>
    <script src="../../assets/js/components/hs.modal-window.js"></script>
    <script src="../../assets/js/components/hs.show-animation.js"></script>
    <script src="../../assets/js/components/hs.slick-carousel.js"></script>
    <script src="../../assets/js/components/hs.cubeportfolio.js"></script>
    <script src="../../assets/js/components/hs.video-player.js"></script>
    <script src="../../assets/js/components/hs.go-to.js"></script>

    <!-- JS Plugins Init. -->
    <!-- Libreria DataTables para talbas -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.css" />
    <!-- <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>-->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs4/dt-1.10.22/datatables.min.js"></script>

    <!-- End Skippy -->
    <script>
    $(window).on('load', function() {
        // initialization of HSMegaMenu component
        $('.js-mega-menu').HSMegaMenu({
            event: 'hover',
            pageContainer: $('.container'),
            breakpoint: 991,
            hideTimeOut: 0
        });
    });

    $(document).on('ready', function() {
        // initialization of header
        $.HSCore.components.HSHeader.init($('#header'));

        // initialization of unfold component
        $.HSCore.components.HSUnfold.init($('[data-unfold-target]'), {
            afterOpen: function() {
                if (!$('body').hasClass('IE11')) {
                    $(this).find('input[type="search"]').focus();
                }
            }
        });

        // initialization of form validation
        $.HSCore.components.HSValidation.init('.js-validate', {
            rules: {
                confirmPassword: {
                    equalTo: '#password'
                }
            }
        });

        // initialization of forms
        $.HSCore.helpers.HSFocusState.init();

        // initialization of malihu scrollbar
        $.HSCore.components.HSMalihuScrollBar.init($('.js-scrollbar'));

        // initialization of autonomous popups
        $.HSCore.components.HSModalWindow.init('[data-modal-target]', '.js-signup-modal', {
            autonomous: true
        });

        // initialization of show animations
        $.HSCore.components.HSShowAnimation.init('.js-animation-link');

        // initialization of slick carousel
        $.HSCore.components.HSSlickCarousel.init('.js-slick-carousel');

        // initialization of cubeportfolio
        $.HSCore.components.HSCubeportfolio.init('.cbp');

        // initialization of video player
        $.HSCore.components.HSVideoPlayer.init('.js-inline-video-player');

        // initialization of go to
        $.HSCore.components.HSGoTo.init('.js-go-to');
    });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- ========== FIN DE ARCHIVOS NECESARIOS ========== -->

</body>

</html>