//Código para Datables

//$('#example').DataTable(); //Para inicializar datatables de la manera más simple

$(document).ready(function() {

    tablaUsuarios = $('#tablaUsuarios').DataTable({

        "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "sProcessing": "Procesando...",
        }


    });



    //Editar 

    $("#Actualizar_Usuario").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxUsuarios.php',
            data: parametros,
            beforeSend: function(objeto) {

            },
            success: function(response) {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Usuario Actualizado Correctamente",
                        icon: 'success',
                    }).then(function() {
                        $('#Modal_Editar_Usuario').modal("toggle");
                        location.reload();

                    });


                }

            }

        });

        event.preventDefault();
    });




    //Insertar 

    $("#Insertar_Usuario").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxUsuarios.php',
            data: parametros,
            beforeSend: function(objeto) {

            },
            success: function(response) {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Usuario Insertado Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });






                }

            }

        });

        event.preventDefault();
    });


    $("#nuevo_Usuario").click(function(event) {

        event.preventDefault();

        window.location = "crearUsuario.php";


    });






});







// Obtener Datos para visualisar en el modal ver datos

function obtener_datos(idempleado) {
    var action = 'obtener_datos';
    var id_empleado = idempleado;

    $.ajax({
        url: './ajax/ajaxUsuarios.php',
        type: "POST",
        async: true,
        data: { action: action, id_empleado: id_empleado },
        success: function(response) {
            if (response != 'error') {

                var info = JSON.parse(response);
                var empleado = info.nombres + ' ' + info.apellidos;

                $('#empleado').val(empleado);
                $('#cui').val(info.dpi);
                $('#telefono').val(info.telefono);
                $('#fnacimiento').val(info.nacimiento);
                $('#fcreacion').val(info.inicio);
                $('#estado').val(info.estado);
                $('#usuario').val(info.usuario);
                $('#tusuario').val(info.tipo);
                $('#sucursal').val(info.sucursal);
                $('#domicilio').val(info.domicilio);

            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}

// Obtiene los datos necesarios para editar el modal de edicion.

function obtener_datos_editar(idempleado) {
    var action = 'obtener_datos';
    var id_empleado = idempleado;

    $.ajax({
        url: './ajax/ajaxUsuarios.php',
        type: "POST",
        async: true,
        data: { action: action, id_empleado: id_empleado },
        success: function(response) {
            if (response != 'error') {



                var info = JSON.parse(response);
                $('#id_empleado2').val(info.idempleado);
                $('#pnombre2').val(info.nombres);
                $('#papellido2').val(info.apellidos);
                $('#usuario2').val(info.usuario);
                $('#pass2').val(info.pass);
                $('#estado2').val(info.estado);
                $('#dpi2').val(info.dpi);
                $('#sexo2').val(info.sexo);
                $('#telefono2').val(info.telefono);
                $('#fnacimiento2').val(info.nacimiento);
                $('#ecivil2').val(info.estado_civil);
                $('#rol2').val(info.tipo_idtipo);
                $('#domicilio2').val(info.domicilio);

            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}