$(document).ready(() => {

    var tablaMesas = $('#tablaMesas').DataTable({

        "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "sProcessing": "Procesando...",
        }
    });


    //Insertar Mesas --> Bodega 

    $('#Insertar_Mesa').submit(function(event) {

        var parameters = $(this).serialize();
        $.ajax({
            type: 'POST',
            url: './ajax/ajaxMesas.php',
            data: parameters,
            beforeSend: function name(params) {

            },
            success: response => {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Mesa Insertada Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });

                }


                if (response == 'replica') {

                    Swal.fire({
                        title: "Mesa ya existente",
                        icon: 'warning',
                    }).then(function() {

                        location.reload();

                    });

                }



            }

        });
        event.preventDefault();
    });



    //Editar 

    $("#Actualizar_Mesa").submit(function(event) {
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxMesas.php',
            data: parametros,
            beforeSend: function() {

            },
            success: response => {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Mesa Actualizada Correctamente",
                        icon: 'success',
                    }).then(function() {
                        $('#Modal_Editar_Mesas').modal("toggle");
                        location.reload();

                    });


                }

            }




        });


        event.preventDefault();


    });


    //Actualizar Asignacion ----> Bodega





    $("#nueva_Mesa").click(event => {

        event.preventDefault();

        window.location = "nuevaMesa.php";


    });





    // End Ready

});



// Obtiene los datos necesarios para editar el modal de edicion.

let obtener_datos_editar = idMesa => {
    var action = 'obtener_datos';
    var id_Mesa = idMesa;

    $.ajax({
        url: './ajax/ajaxMesas.php',
        type: "POST",
        async: true,
        data: { action: action, id_Mesa: id_Mesa },
        success: response => {
            if (response != 'error') {

                var info = JSON.parse(response);
                $('#id_Mesa2').val(info.idmesa);
                $('#numero2').val(info.numero);
                $('#descripcion2').val(info.descripcion);
                $('#sucursalm2').val(info.locacion_idlocacion);


            } else {

                console.log("No existen datos")

            }

        },
        error: error => {
            console.log(error);
        }

    });

}

//Cambiar el estado del producto




let estado_Mesa = id => {
    var action = 'estado_Mesa';
    var id = id;

    $.ajax({
        type: 'POST',
        url: './ajax/ajaxMesas.php',
        data: { action: action, id: id },
        beforeSend: function() {

        },
        success: function(response) {
            if (response == 'successful') {
                Swal.fire({
                    title: "Estado Actualizado Correctamente",
                    icon: 'success',
                }).then(function() {
                    //      $('#Modal_Editar_Mesas').modal("toggle");
                    location.reload();

                });


            }

        }


    });

}