//Código para Datables

//$('#example').DataTable(); //Para inicializar datatables de la manera más simple

$(document).ready(function() {

    gastos = $('#tablaGastos').DataTable({

        "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "sProcessing": "Procesando...",
        }


    });





    //Insertar Gasto

    $("#Insertar_Gasto").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxGasto.php',
            data: parametros,
            beforeSend: function(objeto) {

            },
            success: function(response) {
                if (response = 'successful') {
                    Swal.fire({
                        title: "Tipo de Gasto Insertado Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });






                }

            }

        });

        event.preventDefault();
    });



    //Agregar descripcion de gastos

    $("#Agregar_Gasto").submit(function(event) {
        $('#guardar_datos').attr("disabled", true);
        var parametros = $(this).serialize();
        $.ajax({
            type: "POST",
            url: './ajax/ajaxGasto.php',
            data: parametros,
            beforeSend: function name(params) {

            },
            success: response => {
                if (response == 'successful') {
                    Swal.fire({
                        title: "Gasto Insertado Correctamente",
                        icon: 'success',
                    }).then(function() {

                        location.reload();

                    });

                }


            }

        });

        event.preventDefault();
    });







});



$("#nueva_Mesa").click(event => {

    event.preventDefault();

    window.location = "nuevoGasto.php";


});




// Obtiene los datos necesarios para editar el modal de edicion.

function obtener_datos_editar(idempleado) {
    var action = 'obtener_datos';
    var id_empleado = idempleado;

    $.ajax({
        url: './ajax/ajaxUsuarios.php',
        type: "POST",
        async: true,
        data: { action: action, id_empleado: id_empleado },
        success: function(response) {
            if (response != 'error') {

                var info = JSON.parse(response);
                $('#id_empleado2').val(info.idempleado);
                $('#nombres2').val(info.nombres);
                $('#apellidos2').val(info.apellidos);
                $('#dpi2').val(info.dpi);
                $('#telefono2').val(info.telefono);
                $('#usuario2').val(info.usuario);
                $('#pass2').val(info.pass);
                $('#tusuario2').val(info.idtipo);
                $('#sucursal2').val(info.idsucursal);

            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}




// Anular Gasto

function anular(idgasto) {
    var action = 'anular';
    var id_gasto = idgasto;

    $.ajax({
        url: './ajax/ajaxGasto.php',
        type: "POST",
        async: true,
        data: { action: action, id_gasto: id_gasto },
        success: function(response) {
            if (response = 'successful') {

                Swal.fire({
                    title: " Gasto Anulado Correctamente",
                    icon: 'success',
                }).then(function() {

                    location.reload();


                });





            } else {

                console.log("No existen datos")

            }

        },
        error: function(error) {
            console.log(error);
        }

    });

}













function refrescar(tiempo) {
    //Cuando pase el tiempo elegido la página se refrescará 
    setTimeout("location.reload(true);", tiempo);
}





function generarPDF(idgasto) {
    var ancho = 1000;
    var alto = 800;
    // calcular posicion x,y para centrar la venta

    var x = parseInt((window.screen.width / 2) - (ancho / 2));
    var y = parseInt((window.screen.width / 2) - (alto / 2));

    $url = 'pdf/documentos/gasto_pdf.php?gasto=' + idgasto;
    window.open($url, "gasto", "left" + x + ",top=" + y + ",height" + alto + ",width" + ancho + ",scrollbar=si,location=no,resizable=si,menubar=no")
}